/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioResourceAssignment;
import filenet.sim.api.VWScenarioResourceDefinition;
import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.api.VWScenarioValidationError;
import filenet.vw.api.VWException;
import filenet.vw.base.VWString;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public final class VWScenarioRoleAssignment
implements Serializable,
Cloneable {
    private VWScenarioShiftDefinition m_shiftDef = null;
    private String m_roleName = null;
    private Map m_resources = Collections.synchronizedMap(new HashMap());

    protected VWScenarioRoleAssignment(String roleName, VWScenarioShiftDefinition shift) throws VWException {
        this.m_shiftDef = shift;
        this.m_roleName = roleName;
        this.m_shiftDef.getScenario().getRole(roleName).addRoleAssignmentToCache(this);
    }

    protected VWScenarioRoleAssignment(String roleName) throws VWException {
        this.m_roleName = roleName;
    }

    public String getRoleName() {
        return this.m_roleName;
    }

    protected void setRoleName(String roleName) throws VWException {
        VWScenarioDefinition scenario = this.getShift().getScenario();
        if (roleName == null) {
            throw new VWException("sim.api.VWScenarioRoleAssignment.NullRoleNameParameter", "The roleName parameter can not be null.");
        }
        if (this.getShift().hasRole(roleName)) {
            throw new VWException("sim.api.VWScenarioRoleAssignment.RoleAssignmentAlreadyExists", "Role name {0} is invalid (a role with that name has already been assigned to shift {1}).", roleName, this.getShift().getName());
        }
        if (!scenario.hasRole(roleName)) {
            throw new VWException("sim.api.VWScenarioRoleAssignment.InvalidRoleName", "Role name {0} is invalid (a role with that name does not exist within the scenario.)", roleName);
        }
        this.getShift().updateRole(this.getRoleName(), roleName);
        this.m_roleName = roleName;
    }

    public String toString() {
        return this.getRoleName();
    }

    public VWScenarioResourceAssignment createResourceAssignment(String resourceName, float performance) throws VWException {
        if (resourceName == null) {
            throw new VWException("sim.api.VWScenarioRoleAssignment.NullResourceNameParameter", "The resource name parameter can not be null.");
        }
        if (this.m_resources.containsKey(resourceName)) {
            throw new VWException("sim.api.VWScenarioRoleAssignment.ResourceAssignmentAlreadyExists", "A resource with the name {0} has already been assigned to this role.", resourceName);
        }
        if (!this.getShift().getScenario().hasResource(resourceName)) {
            throw new VWException("sim.api.VWScenarioRoleAssignment.ResourceNotFound", "Invalid resource name. A resource with the name {0} has not been defined for this scenario.", resourceName);
        }
        if (this.getShift().getScenario().getResource(resourceName).isAssignedToShift(this.getShift().getName())) {
            throw new VWException("sim.api.VWScenarioRoleAssignment.ResourceAlreadyAssignedToShift", "Resource {0} is already assigned to shift {1} under a different role.", resourceName, this.getShift().getName());
        }
        VWScenarioResourceAssignment resourceAssignment = new VWScenarioResourceAssignment(this.getShift().getScenario().getResource(resourceName), performance, this);
        this.m_resources.put(resourceName, resourceAssignment);
        return resourceAssignment;
    }

    protected VWScenarioResourceAssignment createResourceAssignment(VWScenarioResourceDefinition resource, float performance) throws VWException {
        VWScenarioResourceAssignment resourceAssignment = new VWScenarioResourceAssignment(resource, performance, this);
        this.m_resources.put(resource.getName(), resourceAssignment);
        return resourceAssignment;
    }

    public VWScenarioResourceAssignment[] getResourceAssignments() {
        if (this.m_resources.size() == 0) {
            return null;
        }
        return this.m_resources.values().toArray(new VWScenarioResourceAssignment[0]);
    }

    public VWScenarioResourceAssignment getResourceAssignment(String resourceName) throws VWException {
        if (resourceName == null) {
            throw new VWException("sim.api.VWScenarioRoleAssignment.NullResourceNameParameter", "The resourceName parameter can not be null.");
        }
        if (!this.m_resources.containsKey(resourceName)) {
            throw new VWException("sim.api.VWScenarioRoleAssignment.ResourceAssignmentNotFound", "Resource {0} has not been assigned to this role.", resourceName);
        }
        return (VWScenarioResourceAssignment)this.m_resources.get(resourceName);
    }

    public void deleteResourceAssignment(String resourceName) throws VWException {
        if (resourceName == null) {
            throw new VWException("sim.api.VWScenarioRoleAssignment.NullResourceNameParameter", "The resourceName parameter can not be null.");
        }
        if (!this.m_resources.containsKey(resourceName)) {
            throw new VWException("sim.api.VWScenarioRoleAssignment.ResourceAssignmentNotFound", "Resource {0} has not been assigned to this shift.", resourceName);
        }
        this.getResourceAssignment(resourceName).releaseReferences();
        this.m_resources.remove(resourceName);
    }

    public void validate(Vector EDefVector) throws VWException {
        VWScenarioValidationError theError;
        VWString theMessage;
        if (!this.getShift().getScenario().hasRole(this.getRoleName())) {
            theMessage = new VWString("sim.api.VWScenarioRoleAssignment.InvalidRoleAssigned", "Invalid role {0} assigned to shift {1}. The role has not been defined for this scenario.", this.getRoleName(), this.getShift().getName());
            theError = new VWScenarioValidationError(5, 1, this.getShift().getName(), this.getRoleName(), theMessage.toString());
            EDefVector.addElement(theError);
        } else if (this.m_resources.size() == 0) {
            theMessage = new VWString("sim.api.VWScenarioRoleAssignment.NoResourcesAssigned", "Job does not have any resources assigned.");
            theError = new VWScenarioValidationError(5, 2, this.getShift().getName(), this.getRoleName(), theMessage.toString());
            EDefVector.addElement(theError);
        }
        Iterator i = this.m_resources.values().iterator();
        while (i.hasNext()) {
            ((VWScenarioResourceAssignment)i.next()).validate(EDefVector);
        }
    }

    protected Object clone() {
        VWScenarioRoleAssignment clone = null;
        try {
            clone = (VWScenarioRoleAssignment)super.clone();
            clone.m_resources = Collections.synchronizedMap(new HashMap());
            for (String key : this.m_resources.keySet()) {
                VWScenarioResourceAssignment value = (VWScenarioResourceAssignment)((VWScenarioResourceAssignment)this.m_resources.get(key)).clone();
                value.setRole(clone);
                clone.m_resources.put(key, value);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    protected void updateResource(String oldName, String newName) throws VWException {
        VWScenarioResourceAssignment resource = (VWScenarioResourceAssignment)this.m_resources.remove(oldName);
        if (resource != null) {
            this.m_resources.put(newName, resource);
        }
    }

    public boolean hasResource(String resourceName) throws VWException {
        return this.m_resources.containsKey(resourceName);
    }

    protected boolean hasResources() throws VWException {
        return this.m_resources.size() > 0;
    }

    protected void setShift(VWScenarioShiftDefinition shift) throws VWException {
        this.m_shiftDef = shift;
        shift.getScenario().getRole(this.getRoleName()).addRoleAssignmentToCache(this);
    }

    public VWScenarioShiftDefinition getShift() {
        return this.m_shiftDef;
    }

    protected void releaseReferences() throws VWException {
        this.getShift().getScenario().getRole(this.getRoleName()).removeRoleAssignmentFromCache(this);
        Iterator i = this.m_resources.values().iterator();
        while (i.hasNext()) {
            ((VWScenarioResourceAssignment)i.next()).releaseReferences();
        }
    }
}

